<?php
// Set headers for API response
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database conn
include_once 'db.php';

// Get raw input data
$data = json_decode(file_get_contents("php://input"), true);

// Extract 'id' from raw JSON
$id = $data['id'] ?? null;

if (!$id) {
    // Return an error if 'id' is missing
    echo json_encode([
        "status" => "error",
        "message" => "Product ID is required"
    ]);
    exit;
}

try {
    // Query to fetch product details
    $sql = "SELECT 
                Product_id, 
                Product_name, 
                MRP, 
                sale_price_tax, 
                Selling_price, 
                Tax_percentage,
                Discount_percentage 
            FROM 
                product 
            WHERE 
                Product_name = '" . mysqli_real_escape_string($conn, $id) . "' 
                AND delete_status = 0";

    $result = mysqli_query($conn, $sql);

    if (!$result) {
        throw new Exception("Query failed: " . mysqli_error($conn));
    }

    // Initialize products array
    $products_arr = [];

    while ($row = mysqli_fetch_assoc($result)) {
        $products_arr[] = [
            "productid" => $row['Product_id'] ?? null,
            "productname" => $row['Product_name'] ?? null,
            "mrp" => $row['MRP'] ?? null,
            "saleprice" => $row['Selling_price'] ?? null,
            "salepricetax" => $row['sale_price_tax'] ?? null,
            "taxpercentage" => $row['Tax_percentage'] ?? null,
            "discountpercentage" => $row["Discount_percentage"] ?? null
        ];
    }

    // Return the products as JSON
    echo json_encode($products_arr);

} catch (Exception $e) {
    // Handle any errors
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}

// Close the database conn
mysqli_close($conn);
?>
